clear;clc;
close all;

cepath='D:\MATLAB-2018\CompEcon\'; path([cepath 'cetools;' cepath 'cedemos'],path);

%addpath([pwd,'/Exogenous_files']) // pwd: returns the path to the current
%folder

%% Parameters and Exo vars
e = 0.70;
Psim = 0.5; %0.5, 0.496; 
Psif = 0.45; %0.45, 0.501; (if Psim <= Psif, solver failed)

wU_f_base = 1; 
wU_m_base = 1.35; 
wS_f_base = 1.61; 
wS_m_base = 2.06; 

mu = 0.50;

%% Sex ratio
Nfemale = (0.80:0.01:0.97)'; % ' ---> column vector
ratio = 1./Nfemale;
n = size(Nfemale,1);
 
%% Edu_correlation, Gini, Theta and Pi
CORR1 = zeros(n,1);
CORR_endo = zeros(n,1);
Gini_Sergei = zeros(n,1);
Gini_1 = zeros(n,1);
Gini_2 = zeros(n,1);
Theta = zeros(n,4);
Pi = zeros(n,6);
Theil_T = zeros(n,1);
Theil_L = zeros(n,1);
CV = zeros(n,1);
qvalue = zeros(8,n);

beta=3;

%% Endogenous of education decision
EPsim_grid = (0:0.01:1)';
EPsim_size = length(EPsim_grid);

EPsif_grid = (0:0.01:1)';
EPsif_size = length(EPsif_grid); 

EPsi = zeros(n,2);

%% Iteration 

for i = 1:n
    wU_f = wU_f_base;
    wU_m = wU_m_base; 
    wS_f = wS_f_base; 
    wS_m = wS_m_base; 
    
    Nf = Nfemale(i)
    
    % CP(Dis,0,1)
    % need define f that returns the function value (Dis) and Jacobian at
    % arbitrary point, see MeFuncCP
    
    func = @(q) MeEquiMatch(q, Nf, Psim, Psif, e, wS_m, wS_f, wU_m, wU_f, mu); %
    
    x0 = ones(8,1)/2; % initial guess of x
    
    [~, ~] = MeFuncCP(x0, func); % What does this mean Warning: Failure to converge in ncpsolve 
    
    myfun = @(q) MeFuncCP(q, func); % 
    
    qlow  = zeros(8,1); % lower bound
    qhigh = ones(8,1); % upper bound
    
    qq = ncpsolve(myfun, qlow, qhigh, x0);
    % applying Newton's method, use semismooth formulation [phi^{+-}(u,v)=u+v+-\sqrt{u^2+v^2}]
    % to solve CP use minmax change default option 
    % optset('ncpsolve','type','minmax')
    
    %  qvalue(i) = qq;
    
    % Dis = MeEquiMatch(qq);  solved q, compute Dis value
    Dis = func(qq)';
    
    if max(abs(Dis))>1e-6
        disp('solver failed')
        pause
    end
    
    CORR1(i) = MeEduCorr(qq, Nf, Psim, Psif);
    
    [thetaSm(i), thetaUm(i), thetaSf(i), thetaUf(i)] = Metheta(qq, Nf, Psim, Psif);
    [piss(i), pisu(i), pius(i), piuu(i), pis(i), piu(i)] = Mepi(qq, Nf, Psim, Psif);
    
    Theta = [thetaSm(i); thetaUm(i); thetaSf(i); thetaUf(i)]';
    
    Pi = [piss(i); pisu(i); pius(i); piuu(i); pis(i); piu(i)]'; 

    qSS_m(i) = qq(1);
    qSS_f(i) = qq(2);
    qSU_m(i) = qq(3);
    qUS_f(i) = qq(4);
    qUS_m(i) = qq(5);
    qUU_m(i) = qq(6);
    qSU_f(i) = qq(7);
    qUU_f(i) = qq(8);

    qvalue = [qSS_m; qSS_f; qSU_m; qUS_f; qUS_m; qUU_m; qSU_f; qUU_f]';
    
    %% Gini of Sergei
    
    income = Meincome(wS_m, wS_f, wU_m, wU_f);
    
    fraction = [piss, pisu, pius, piuu, pis, piu]'; % does the order matter: no
    % 1, 2, 3, 4, 5, 6
    Gini_Sergei(i) = MeGini_test_Serhiy(income,fraction);
    
    %% Gini of my own
    
    [Gini_1(i), Gini_2(i)] = MeGini_test_myself(qq, Nf, Psim, Psif, wS_m, wS_f, wU_m, wU_f);
  
    %% Inequality measures

    [CV(i), CV_2(i), Theil_T(i), Theil_T_2(i), Theil_L(i), Theil_L_2(i), VarianceLog1(i), VarianceLog2(i), AssortHHIncPremium(i), AssortHHIncPremium2(i), E_beta(i), E_beta2(i)] = ...
    MeIneqMeasures(beta, qq, Nf, Psim, Psif, wS_m, wS_f, wU_m, wU_f);

    %% Solve endogenous education decision
    
    func = @(EPsi) MeEVagent(EPsi, Nf, e, wU_f, wU_m, wS_f, wS_m, qq); %
    
    y0 = ones(2,1)/2; % initial guess of y
    
    [fval, fjac] = MeFuncCP_Edu(y0, func); % What does this mean Warning: Failure to converge in ncpsolve 
    
    myfun = @(EPsi) MeFuncCP_Edu(EPsi, func); % 
    
    EPsilow  = zeros(2,1); % lower bound
    EPsihigh = ones(2,1); % upper bound
    
    EPsi_value = ncpsolve(myfun, EPsilow, EPsihigh, y0)
 
    Dis = func(EPsi_value)';
    
    if max(abs(Dis))>1e-6
        disp('solver failed')
        pause
    end
    
    EPsim(i) = EPsi_value(1);
    
    EPsif(i) = EPsi_value(2);
    
    %% Education correlation with endogenous education decision
    % has to be put in the loop, otherwise will only show one obs

    Psim_endo = EPsim(i);
    Psif_endo = EPsif(i);
    
    CORR_endo(i) = MeEduCorr(qq, Nf, Psim_endo, Psif_endo);

end


